# -*- coding: utf-8 -*-
try:
    from json import loads
except ImportError:
    from simplejson import loads

from time import time, sleep
from platform import system
from hashlib import md5
from base64 import b64decode

import os

from thread import start_new_thread
from pycurl import FORM_FILE, LOW_SPEED_TIME, USERAGENT

from module.network.RequestFactory import getURL, getRequest
from module.network.HTTPRequest import BadHeader

from module.plugins.Hook import Hook

class JdCaptchaException(Exception):
    def __init__(self, err):
        self.err = err

    def getCode(self):
        return self.err

    def __str__(self):
        return "<JdCaptchaException %s>" % self.err

    def __repr__(self):
        return "<JdCaptchaException %s>" % self.err

class JdCaptcha(Hook):
    __name__ = "JdCaptcha"
    __version__ = "1.0"
    __description__ = """send captchas to jdCaptcha"""
    __config__ = [("activated", "bool", "Activated", True),
                  ("username", "str", "Username", ""),
                  ("passkey", "password", "Password", ""),]
    __author_name__ = ("Vincent Debout")
    __author_mail__ = ("vincent.debout@vincescodes.com")

    API_URL = "http://%host:%port/jdcaptcha/api.php"
    API_VERSION = "6.0.1"
    UPDATE_URL = "http://www.vincescodes.com/jdcaptcha/update.php"

    def setup(self):
        self.info = {}

    def submit(self, captcha, captchaType="file", match=None):
        #if type(captcha) == str and captchaType == "file":
        #    raise jdCaptchaException("Invalid Type")
        assert captchaType in ("file", "url-jpg", "url-jpeg", "url-png", "url-bmp")

        result = "FAIL"
        
        req = getRequest()

        timeout = time() + 300

        #raise timeout threshold
        req.c.setopt(LOW_SPEED_TIME, 80)
        req.c.setopt(USERAGENT, "pyload - v" + JdCaptcha.API_VERSION)

        host = "www.vincescodes.com"
        port = 80

        sleep(1)

        try:
            json = req.load(JdCaptcha.API_URL.replace("%host", host).replace("%port", str(port)), post={"username": self.getConfig("username"),
                                                                                                        "password": self.getConfig("passkey"),
                                                                                                        "action":"submit",
                                                                                                        "version":JdCaptcha.API_VERSION,
                                                                                                        "client":"pyload-python-" + system().lower(),
                                                                                                        "timeout":"300",
                                                                                                        "file": (FORM_FILE, captcha)}, multipart=True)
        finally:
            req.close()

        response = loads(json)
        if response["status"] == "FAIL":
            raise JdCaptchaException(response["status"])

        try:
            host = response["host"]
        except:
            host = "www.vincescodes.com"

        try:
            port = response["port"]
        except:
            port = "80"
            
        cid = response["cid"]
        try:
            delay = response["delay"]
        except:
            delay = 30
            
        while(time() < timeout):
            sleep(delay)
            req = getRequest()
            req.c.setopt(LOW_SPEED_TIME, 80)
            req.c.setopt(USERAGENT, "pyload - v" + JdCaptcha.API_VERSION)
            try:
                json = req.load(JdCaptcha.API_URL.replace("%host", host).replace("%port", str(port)), post={"username": self.getConfig("username"),
                                                                                                            "password": self.getConfig("passkey"),
                                                                                                            "action":"status",
                                                                                                            "version":JdCaptcha.API_VERSION,
                                                                                                            "client":"pyload-python-" + system().lower(),
                                                                                                            "cid":str(cid)}, multipart=True)
            finally:
                req.close()
            response = loads(json)
            if response["status"] == "OK":
                result = response["result"]
                if "update" in response:
                    if response["update"]:
                        req = getRequest()
                        req.c.setopt(LOW_SPEED_TIME, 80)
                        req.c.setopt(USERAGENT, "pyload - v" + JdCaptcha.API_VERSION)
                        try:
                            json = req.load(JdCaptcha.UPDATE_URL, post={"username": self.getConfig("username"),
                                                                        "password": self.getConfig("passkey"),
                                                                        "action":"download",
                                                                        "version":JdCaptcha.API_VERSION,
                                                                        "client":"pyload-python-" + system().lower()}, multipart=True)
                        finally:
                            req.close()
                        response = loads(json)
                        if response["status"] == "OK":
                            for i in range(0, response["count"]):
                                fl = response["files"][i]
                                content = b64decode( fl["content"] )
                                m = md5()
                                m.update( content )
                                if m.hexdigest() == fl["md5"]:
                                    temp = open( os.path.dirname(os.path.realpath(__file__)) + os.sep + fl["name"], "w" )
                                    temp.write( content )
                                    temp.close()
                            req = getRequest()
                            req.c.setopt(LOW_SPEED_TIME, 80)
                            req.c.setopt(USERAGENT, "pyload - v" + JdCaptcha.API_VERSION)
                            try:
                                json = req.load(JdCaptcha.UPDATE_URL, post={"username": self.getConfig("username"),
                                                                            "password": self.getConfig("passkey"),
                                                                            "action":"done",
                                                                            "version":JdCaptcha.API_VERSION,
                                                                            "client":"pyload-python-" + system().lower()}, multipart=True)
                            finally:
                                req.close()
                break
            else:
                try:
                    delay = response["delay"]
                except:
                    delay = 30
                try:
                    host = response["host"]
                except:
                    host = "www.vincescodes.com"
                try:
                    port = response["port"]
                except:
                    port = "80"
                
        
        self.logDebug("result %s" % (result))

        return result

    def newCaptchaTask(self, task):
        if not task.isTextual():
            return False

        if not self.getConfig("username") or not self.getConfig("passkey"):
            return False

	task.handler.append(self)
        task.setWaiting(300)
        start_new_thread(self.processCaptcha, (task,))

    def captchaCorrect(self, task):
        if "ticket" in task.data:
            ticket = task.data["ticket"]

    def captchaInvalid(self, task):
        if "ticket" in task.data:
            ticket = task.data["ticket"]

    def processCaptcha(self, task):
        c = task.captchaFile
        try:
            result = self.submit(c)
        except JdCaptchaException, e:
            task.error = e.getCode()
            return

        if result != "FAIL":
            task.setResult(result)
