/*
 * Decompiled with CFR 0.152.
 */
package fr.morinie.jdcaptcha;

import fr.morinie.jdcaptcha.JdCaptchaServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TestMe {
    private static JdCaptchaServer server;

    public static void main(String[] args) throws Exception {
        String[] path;
        File file;
        server = new JdCaptchaServer();
        if (!server.fileExists("jdCaptcha.properties") && !server.fileExists("jdCaptcha.conf")) {
            System.out.println("The jdCaptcha.conf file is missing. Go to https://www.vincescodes.com/jdcaptcha/jdCaptcha.conf to download it.");
            Thread.sleep(30000L);
            return;
        }
        if (!server.fileExists("jdCaptcha.conf")) {
            server.readProperties("jdCaptcha.properties");
            try {
                server.writeProperties("jdCaptcha.conf");
                file = new File("jdCaptcha.properties");
                file.delete();
            }
            catch (IOException e) {
                System.out.println("The jdCaptcha.properties file could not be converted. Go to https://www.vincescodes.com/jdcaptcha/jdCaptcha.conf to download the new file and delete the jdCaptcha.properties file.");
                Thread.sleep(30000L);
                return;
            }
        }
        if (!(path = (file = new File("jdCaptcha.conf")).getAbsolutePath().split(Pattern.quote(File.separator)))[path.length - 3].equals("methods")) {
            System.out.println("The jdCaptcha plugin is not installed in the correct directory, it should be in the JDONWLOADER_ROOT/jd/captcha/methods/jdCaptcha.");
            System.out.println("  Current path is: " + file.getAbsolutePath());
            return;
        }
        server.readProperties("jdCaptcha.conf");
        if (server.fileExists("input.jpg")) {
            String jacInfo = new Scanner(new File("jacinfo.xml")).useDelimiter("\\Z").next();
            Pattern pattern = Pattern.compile("input-[0-9]+\\.jpg");
            Matcher matcher = pattern.matcher(jacInfo);
            int id = -1;
            if (matcher.find()) {
                String newFile = matcher.group();
                String[] temp = newFile.split("-");
                temp = temp[1].split("\\.");
                id = Integer.parseInt(temp[0]);
            }
            if (id < 0) {
                System.out.println("Internal error");
                Thread.sleep(30000L);
                return;
            }
            TestMe.copyFile(new File("input.jpg"), new File("input-" + id + ".jpg"));
            if (JdCaptchaServer.os.equals("windows")) {
                TestMe.executeCommand("jdCaptcha.bat", "./", true);
            } else {
                TestMe.executeCommand("./jdCaptcha", "./", true);
            }
        } else {
            System.out.println("The input.jpg file is missing!");
            Thread.sleep(30000L);
        }
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static int executeCommand(String command, String directory, boolean wait) {
        Runtime runtime = Runtime.getRuntime();
        int result = -1;
        File file = new File(directory);
        String[] cmd = new String[]{command, file.getAbsolutePath()};
        try {
            Process proc = runtime.exec(cmd, null, file);
            if (wait) {
                result = proc.waitFor();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result;
    }
}

