/*
 * Decompiled with CFR 0.152.
 */
package fr.morinie.jdcaptcha;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpProtocolParams;

public class JdCaptchaServer {
    public static final int JDCAPTCHA_TIMEOUT = 300;
    protected static final String JDCAPTCHA_VERSION = "6.0.1";
    protected static final String JDCAPTCHA_CLIENT = "java-";
    protected static final String JDCAPTCHA_HOST = "www.vincescodes.com";
    protected static final int JDCAPTCHA_PORT = 80;
    private static final String JDCAPTCHA_API_URL = "http://%host:%port/jdcaptcha/api.php";
    private static final String JDCAPTCHA_UPDATE_URL = "http://www.vincescodes.com/jdcaptcha/update.php";
    private static final String JDCAPTCHA_REMOTE_URL = "http://%host:%port/jdcaptcha/remote.php";
    private static String username = null;
    private static String password = null;
    public boolean webinterfaceHttps = false;
    public int remotePort = -1;
    public int webinterfacePort = -1;
    public String remoteHost = "localhost";
    public String webinterfaceHost = "localhost";
    public String webinterfaceLogin = "";
    public String webinterfacePassword = "";
    private static String logfile = null;
    public static String os;

    private static String serverPost(int timeout, String url, String[] names, String[] values, String[] files) {
        String content = null;
        BasicHttpParams httpParameters = new BasicHttpParams();
        if (timeout == 0) {
            HttpConnectionParams.setConnectionTimeout(httpParameters, 4000);
            HttpConnectionParams.setSoTimeout(httpParameters, 10000);
        } else if (timeout > 0) {
            HttpConnectionParams.setConnectionTimeout(httpParameters, timeout * 1000);
            HttpConnectionParams.setSoTimeout(httpParameters, timeout * 1000);
        }
        HttpProtocolParams.setUserAgent(httpParameters, "jdCaptcha - java-" + os + " v" + JDCAPTCHA_VERSION);
        DefaultHttpClient client = new DefaultHttpClient(httpParameters);
        HttpPost post = new HttpPost(url);
        try {
            int i;
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart("username", new StringBody(username, "text/plain", Charset.forName("UTF-8")));
            entity.addPart("password", new StringBody(password, "text/plain", Charset.forName("UTF-8")));
            entity.addPart("version", new StringBody(JDCAPTCHA_VERSION, "text/plain", Charset.forName("UTF-8")));
            entity.addPart("client", new StringBody(JDCAPTCHA_CLIENT + os, "text/plain", Charset.forName("UTF-8")));
            entity.addPart("timeout", new StringBody(String.valueOf(300), "text/plain", Charset.forName("UTF-8")));
            if (names != null) {
                i = 0;
                while (i < names.length) {
                    entity.addPart(names[i], new StringBody(values[i], "text/plain", Charset.forName("UTF-8")));
                    ++i;
                }
            }
            if (files != null) {
                i = 0;
                while (i < files.length) {
                    File file = new File(files[i]);
                    if (file.exists()) {
                        entity.addPart("file", new FileBody(file, "image/jpeg"));
                    }
                    ++i;
                }
            }
            post.setEntity(entity);
            HttpResponse response = client.execute(post);
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String line = "";
            while ((line = rd.readLine()) != null) {
                content = content == null ? line : String.valueOf(content) + "\n" + line;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    public String apiGetStatus(int cid, String host, int port) {
        String url = JDCAPTCHA_API_URL.replace("%host", host);
        url = url.replace("%port", String.valueOf(port));
        return JdCaptchaServer.serverPost(-1, url, new String[]{"action", "cid"}, new String[]{"status", String.valueOf(cid)}, null);
    }

    public String apiSendFile(String id, String hosts) {
        String url = JDCAPTCHA_API_URL.replace("%host", JDCAPTCHA_HOST);
        url = url.replace("%port", String.valueOf(80));
        if (!this.fileExists("input-" + id + ".jpg")) {
            this.logMessage("The captcha file is missing.");
            return null;
        }
        return JdCaptchaServer.serverPost(0, url, new String[]{"action", "hosts"}, new String[]{"submit", hosts}, new String[]{"input-" + id + ".jpg"});
    }

    public String apiSendHosts() {
        String url = JDCAPTCHA_API_URL.replace("%host", JDCAPTCHA_HOST);
        url = url.replace("%port", String.valueOf(80));
        return JdCaptchaServer.serverPost(0, url, new String[]{"action"}, new String[]{"hosts"}, null);
    }

    public String updateGetPackage() {
        return JdCaptchaServer.serverPost(0, JDCAPTCHA_UPDATE_URL, new String[]{"action"}, new String[]{"download"}, null);
    }

    public String updateCheckVersion() {
        return JdCaptchaServer.serverPost(0, JDCAPTCHA_UPDATE_URL, new String[]{"action"}, new String[]{"version"}, null);
    }

    public void updateSetDone() {
        JdCaptchaServer.serverPost(0, JDCAPTCHA_UPDATE_URL, new String[]{"action"}, new String[]{"done"}, null);
    }

    public String remoteDisable() {
        return JdCaptchaServer.serverPost(0, JDCAPTCHA_REMOTE_URL, new String[]{"action"}, new String[]{"disable"}, null);
    }

    public String remoteGetStatus(String host, int port) {
        String url = JDCAPTCHA_REMOTE_URL.replace("%host", host);
        url = url.replace("%port", String.valueOf(port));
        return JdCaptchaServer.serverPost(3600, url, new String[]{"action"}, new String[]{"status"}, null);
    }

    public boolean fileExists(String filename) {
        boolean result = true;
        File file = new File(filename);
        result &= file.exists();
        result &= file.getAbsoluteFile().exists();
        result &= file.canRead();
        return result &= file.isFile();
    }

    public void updateFromOldRelease() {
        if (this.fileExists("jdCaptcha.properties")) {
            try {
                this.readProperties("jdCaptcha.properties");
                this.writeProperties("jdCaptcha.conf");
                File file = new File("jdCaptcha.properties");
                file.delete();
            }
            catch (IOException e) {
                System.out.println("The jdCaptcha.properties file could not be converted. Go to https://www.vincescodes.com/jdcaptcha/jdCaptcha.conf to download the new file and delete the jdCaptcha.properties file.");
            }
        }
    }

    public void readProperties(String fileName) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(fileName));
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.equals("username")) {
                username = props.getProperty(key).trim();
            }
            if (key.equals("api_password")) {
                password = props.getProperty(key).trim();
            }
            if (key.equals("logfile")) {
                logfile = props.getProperty(key).trim();
            }
            if (key.equals("webinterface_https")) {
                this.webinterfaceHttps = props.getProperty(key).trim().equals("true");
            }
            if (key.equals("remote_port") && !props.getProperty(key).trim().equals("false")) {
                this.remotePort = Integer.valueOf(props.getProperty(key).trim());
            }
            if (key.equals("remote_host")) {
                this.remoteHost = props.getProperty(key).trim();
            }
            if (key.equals("webinterface_port") && !props.getProperty(key).trim().equals("false")) {
                this.webinterfacePort = Integer.valueOf(props.getProperty(key).trim());
            }
            if (key.equals("webinterface_host")) {
                this.webinterfaceHost = props.getProperty(key).trim();
            }
            if (key.equals("webinterface_login")) {
                this.webinterfaceLogin = props.getProperty(key).trim();
            }
            if (!key.equals("webinterface_password")) continue;
            this.webinterfacePassword = props.getProperty(key).trim();
        }
        os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            os = "windows";
        } else if (os.indexOf("linux") >= 0) {
            os = "linux";
        } else if (os.indexOf("mac") >= 0) {
            os = "mac";
        }
    }

    public void writeProperties(String fileName) throws IOException {
        Properties props = new Properties();
        if (username != null) {
            props.setProperty("username", username);
        }
        if (password != null) {
            props.setProperty("api_password", password);
        }
        if (logfile != null) {
            props.setProperty("logfile", logfile);
        }
        props.setProperty("webinterface_https", this.webinterfaceHttps ? "true" : "false");
        if (this.remotePort >= 0) {
            props.setProperty("remote_port", String.valueOf(this.remotePort));
        }
        props.setProperty("remote_host", this.remoteHost);
        if (this.webinterfacePort >= 0) {
            props.setProperty("webinterface_port", String.valueOf(this.webinterfacePort));
        }
        props.setProperty("webinterface_host", this.webinterfaceHost);
        if (!this.webinterfaceLogin.equals("")) {
            props.setProperty("webinterface_login", this.webinterfaceLogin);
            props.setProperty("webinterface_password", this.webinterfacePassword);
        }
        props.store(new FileOutputStream(fileName), "");
    }

    public void logMessage(String message) {
        System.out.println(message);
        if (logfile != null) {
            DateFormat df = DateFormat.getDateInstance();
            try {
                PrintWriter log = new PrintWriter(new BufferedWriter(new FileWriter(logfile, true)));
                log.print("[" + df.format(new Date()) + " ");
                df = DateFormat.getTimeInstance();
                log.println(String.valueOf(df.format(new Date())) + "]: " + message);
                log.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

