/*
 * Decompiled with CFR 0.152.
 */
package fr.morinie.jdcaptcha;

import fr.morinie.jdcaptcha.JdCaptchaServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpProtocolParams;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class jdCaptchaRemote {
    private static ArrayList<String> hosts = new ArrayList();
    private static ArrayList<HashMap<String, Object>> files = new ArrayList();
    private static JdCaptchaServer server;

    jdCaptchaRemote() {
    }

    public static void main(String[] args) throws Exception {
        server = new JdCaptchaServer();
        server.readProperties("jdCaptcha.conf");
        jdCaptchaRemote.getHostList();
        String remoteUrl = null;
        if (jdCaptchaRemote.server.remotePort >= 0 && jdCaptchaRemote.server.webinterfacePort >= 0) {
            String webCheck;
            remoteUrl = "http://" + jdCaptchaRemote.server.remoteHost + ":" + jdCaptchaRemote.server.remotePort;
            String downloadStatus = jdCaptchaRemote.getRemote(String.valueOf(remoteUrl) + "/get/downloadstatus");
            if (downloadStatus == null) {
                jdCaptchaRemote.server.remotePort = -1;
            }
            if ((webCheck = jdCaptchaRemote.getWebinterface(null, null)) == null) {
                jdCaptchaRemote.server.webinterfacePort = -1;
            }
        }
        if (jdCaptchaRemote.server.remotePort < 0 || jdCaptchaRemote.server.webinterfacePort < 0) {
            server.remoteDisable();
        } else {
            JSONObject status = null;
            boolean last = false;
            String host = "www.vincescodes.com";
            int port = 80;
            while (status == null || status.has("disable") && status.getBoolean("disable")) {
                int delay;
                String content = server.remoteGetStatus(host, port);
                status = content != null ? new JSONObject(content) : null;
                if (status != null && status.has("status") && status.getString("status").equals("OK")) {
                    if (status.has("host")) {
                        host = status.getString("host");
                    }
                    if (status.has("port")) {
                        port = status.getInt("port");
                    }
                    delay = status.getInt("delay");
                    if (last != status.getBoolean("disable")) {
                        HashMap<String, Object> item;
                        last = status.getBoolean("disable");
                        InputStream alllistXML = jdCaptchaRemote.getRemote(String.valueOf(remoteUrl) + "/get/downloads/alllist", true);
                        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                        Document doc = dBuilder.parse(alllistXML);
                        doc.getDocumentElement().normalize();
                        NodeList nList = doc.getElementsByTagName("package");
                        int id = 0;
                        files.clear();
                        int i = 0;
                        while (i < nList.getLength()) {
                            Node nNode = nList.item(i);
                            if (nNode.getNodeType() == 1) {
                                NodeList nChilds = nNode.getChildNodes();
                                int did = 0;
                                int j = 0;
                                while (j < nChilds.getLength()) {
                                    Node nFile = nChilds.item(j);
                                    if (nFile.getNodeType() == 1) {
                                        NamedNodeMap attributes = nFile.getAttributes();
                                        item = new HashMap();
                                        int k = 0;
                                        while (k < attributes.getLength()) {
                                            Node aNode = attributes.item(k);
                                            item.put(aNode.getNodeName(), aNode.getNodeValue());
                                            ++k;
                                        }
                                        item.put("id", id);
                                        item.put("did", did);
                                        ++did;
                                        files.add(item);
                                    }
                                    ++j;
                                }
                                ++id;
                            }
                            ++i;
                        }
                        if (last) {
                            i = 0;
                            while (i < files.size()) {
                                item = files.get(i);
                                String fileHost = item.get("file_status").toString().toLowerCase();
                                if (Integer.parseInt(item.get("file_speed").toString()) == 0 && fileHost.indexOf("eta") < 0 && fileHost.indexOf("captcha") < 0 && hosts.contains(item.get("file_hoster").toString())) {
                                    jdCaptchaRemote.getWebinterface(new String[]{"selected_dowhat_index", "do", "package_single_download"}, new String[]{"deactivate", "submit", String.valueOf(item.get("id").toString()) + "+" + item.get("did").toString()});
                                }
                                ++i;
                            }
                        } else {
                            i = 0;
                            while (i < files.size()) {
                                item = files.get(i);
                                if (Integer.parseInt(item.get("file_speed").toString()) == 0 && hosts.contains(item.get("file_hoster").toString())) {
                                    jdCaptchaRemote.getWebinterface(new String[]{"selected_dowhat_index", "do", "package_single_download"}, new String[]{"activate", "submit", String.valueOf(item.get("id").toString()) + "+" + item.get("did").toString()});
                                }
                                ++i;
                            }
                            jdCaptchaRemote.getRemote(String.valueOf(remoteUrl) + "/action/start");
                            delay = 0;
                        }
                    }
                } else {
                    delay = status == null ? 0 : 3600;
                }
                if (delay <= 0) continue;
                Thread.sleep(delay * 1000);
            }
        }
    }

    private static void getHostList() throws FileNotFoundException {
        String jacInfo = new Scanner(new File("jacinfo.xml")).useDelimiter("\\Z").next();
        Pattern pattern = Pattern.compile("services=\".+\"");
        Matcher matcher = pattern.matcher(jacInfo);
        hosts.clear();
        if (matcher.find()) {
            String[] temp = matcher.group().split("\"");
            temp = temp[1].split(";");
            int i = 0;
            while (i < temp.length) {
                hosts.add(temp[i]);
                ++i;
            }
        }
    }

    private static InputStream getRemote(String url, boolean dummy) throws ClientProtocolException, IOException {
        BasicHttpParams httpParameters = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(httpParameters, 5000);
        HttpConnectionParams.setSoTimeout(httpParameters, 5000);
        HttpProtocolParams.setUserAgent(httpParameters, "jdCaptcha v6.0.1");
        DefaultHttpClient client = new DefaultHttpClient(httpParameters);
        HttpGet get = new HttpGet(url);
        HttpResponse response = client.execute(get);
        return response.getEntity().getContent();
    }

    private static String getRemote(String url) throws ClientProtocolException, IOException {
        String content = null;
        BufferedReader rd = new BufferedReader(new InputStreamReader(jdCaptchaRemote.getRemote(url, true)));
        String line = "";
        while ((line = rd.readLine()) != null) {
            content = content == null ? line : String.valueOf(content) + "\n" + line;
        }
        return content;
    }

    private static String getWebinterface(String[] names, String[] values) throws ClientProtocolException, IOException {
        String content = null;
        String webinterfaceUrl = "http" + (jdCaptchaRemote.server.webinterfaceHttps ? "s" : "") + "://";
        webinterfaceUrl = String.valueOf(webinterfaceUrl) + jdCaptchaRemote.server.webinterfaceHost + ":" + jdCaptchaRemote.server.webinterfacePort + "/index.tmpl";
        BasicHttpParams httpParameters = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(httpParameters, 5000);
        HttpConnectionParams.setSoTimeout(httpParameters, 5000);
        HttpProtocolParams.setUserAgent(httpParameters, "jdCaptcha v6.0.1");
        DefaultHttpClient client = new DefaultHttpClient(httpParameters);
        if (!jdCaptchaRemote.server.webinterfaceLogin.equals("")) {
            ((AbstractHttpClient)client).getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), new UsernamePasswordCredentials(jdCaptchaRemote.server.webinterfaceLogin, jdCaptchaRemote.server.webinterfacePassword));
        }
        String url = webinterfaceUrl;
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                url = i == 0 ? String.valueOf(url) + "?" + names[i] + "=" + values[i] : String.valueOf(url) + "&" + names[i] + "=" + values[i];
                ++i;
            }
        }
        HttpGet get = new HttpGet(url);
        HttpResponse response = client.execute(get);
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        String line = "";
        while ((line = rd.readLine()) != null) {
            content = content == null ? line : String.valueOf(content) + "\n" + line;
        }
        return content;
    }
}

