/*
 * Decompiled with CFR 0.152.
 */
package fr.morinie.jdcaptcha;

import fr.morinie.jdcaptcha.JdCaptchaServer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class jdCaptcha {
    private static JdCaptchaServer server;

    jdCaptcha() {
    }

    public static void main(String[] args) throws Exception {
        File file;
        server = new JdCaptchaServer();
        server.updateFromOldRelease();
        server.readProperties("jdCaptcha.conf");
        int newID = 0;
        while ((file = new File("input-" + newID + ".jpg")).exists()) {
            ++newID;
        }
        String[] XMLList = jdCaptcha.writeXMLFile(newID);
        long timeout = System.currentTimeMillis() + 300000L;
        JSONObject status = jdCaptcha.sendFile(XMLList[1], XMLList[0]);
        boolean startUpdater = false;
        boolean startRemote = false;
        file = new File("input-" + XMLList[1] + ".jpg");
        file.delete();
        file = new File("output-" + XMLList[1] + ".txt");
        file.delete();
        if (status == null) {
            server.logMessage("The server is not reachable, try later.");
        }
        if (status != null && status.has("hosts") && !status.getString("hosts").equals("")) {
            jdCaptcha.writeXMLFile(status.getString("hosts"));
            server.apiSendHosts();
        }
        if (status != null && status.has("remote")) {
            startRemote = status.getBoolean("remote");
        }
        if (status != null && status.getString("status").equals("OK")) {
            int cid = status.getInt("cid");
            int delay = 30;
            int port = 80;
            String host = "www.vincescodes.com";
            if (status.has("delay")) {
                delay = status.getInt("delay");
            }
            if (status.has("port")) {
                port = status.getInt("port");
            }
            if (status.has("host")) {
                host = status.getString("host");
            }
            while (System.currentTimeMillis() < timeout) {
                Thread.sleep(delay * 1000);
                JSONObject result = jdCaptcha.getStatus(cid, host, port);
                if (result != null && result.getString("status").equals("OK")) {
                    BufferedWriter output = new BufferedWriter(new FileWriter("output-" + XMLList[1] + ".txt"));
                    output.write(result.getString("result"));
                    output.close();
                    if (result.has("update")) {
                        startUpdater = result.getBoolean("update");
                    }
                    if (!result.has("remote")) break;
                    startRemote = result.getBoolean("remote");
                    break;
                }
                if (result != null) {
                    if (result.has("delay")) {
                        delay = result.getInt("delay");
                    }
                    if (status.has("port")) {
                        port = status.getInt("port");
                    }
                    if (!status.has("host")) continue;
                    host = status.getString("host");
                    continue;
                }
                delay = 30;
            }
        }
        if (startUpdater) {
            if (JdCaptchaServer.os.equals("windows")) {
                jdCaptcha.executeCommand("jdCaptchaUpdater.bat", "./", false);
            } else {
                jdCaptcha.executeCommand("./jdCaptchaUpdater", "./", false);
            }
        }
        if (startRemote) {
            if (JdCaptchaServer.os.equals("windows")) {
                jdCaptcha.executeCommand("jdCaptchaRemote.bat", "./", false);
            } else {
                jdCaptcha.executeCommand("./jdCaptchaRemote", "./", false);
            }
        }
    }

    public static String getContents(File aFile) {
        StringBuilder contents = new StringBuilder();
        try {
            BufferedReader input = new BufferedReader(new FileReader(aFile));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return contents.toString();
    }

    public static int executeCommand(String command, String directory, boolean wait) {
        Runtime runtime = Runtime.getRuntime();
        int result = -1;
        File file = new File(directory);
        String[] cmd = new String[]{command, file.getAbsolutePath()};
        try {
            Process proc = runtime.exec(cmd, null, file);
            if (wait) {
                result = proc.waitFor();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String convertStreamToStr(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    private static JSONObject getStatus(int cid, String host, int port) {
        JSONObject result = null;
        try {
            result = new JSONObject(server.apiGetStatus(cid, host, port));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static JSONObject sendFile(String newID, String hosts) {
        JSONObject result = null;
        try {
            String status = server.apiSendFile(newID, hosts);
            if (status != null) {
                result = new JSONObject(status);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static void writeXMLFile(String hosts) throws SAXException, IOException, ParserConfigurationException {
        File file = new File("jacinfo.xml");
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(file);
        doc.getDocumentElement().normalize();
        NodeList nList = doc.getElementsByTagName("*");
        PrintWriter jacinfo = new PrintWriter(new BufferedWriter(new FileWriter("jacinfo.xml")));
        jacinfo.println("<jDownloader>");
        int i = 0;
        while (i < nList.getLength()) {
            Node node = nList.item(i);
            if (!node.getNodeName().equals(doc.getDocumentElement().getNodeName())) {
                jacinfo.print("  <" + node.getNodeName());
                NamedNodeMap attributes = node.getAttributes();
                int j = 0;
                while (j < attributes.getLength()) {
                    Node attributeNode = attributes.item(j);
                    jacinfo.print(" " + attributeNode.getNodeName());
                    String value = attributeNode.getNodeValue();
                    if (attributeNode.getNodeName().equals("services")) {
                        value = hosts;
                    }
                    jacinfo.print("=\"" + value + "\"");
                    ++j;
                }
                jacinfo.println(" />");
            }
            ++i;
        }
        jacinfo.println("</jDownloader>");
        jacinfo.close();
    }

    private static String[] writeXMLFile(int newId) throws ParserConfigurationException, SAXException, IOException {
        String[] result = new String[2];
        File file = new File("jacinfo.xml");
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(file);
        doc.getDocumentElement().normalize();
        NodeList nList = doc.getElementsByTagName("*");
        PrintWriter jacinfo = new PrintWriter(new BufferedWriter(new FileWriter("jacinfo.xml")));
        jacinfo.println("<jDownloader>");
        int i = 0;
        while (i < nList.getLength()) {
            Node node = nList.item(i);
            if (!node.getNodeName().equals(doc.getDocumentElement().getNodeName())) {
                jacinfo.print("  <" + node.getNodeName());
                NamedNodeMap attributes = node.getAttributes();
                int j = 0;
                while (j < attributes.getLength()) {
                    Node attributeNode = attributes.item(j);
                    jacinfo.print(" " + attributeNode.getNodeName());
                    String value = attributeNode.getNodeValue();
                    if (attributeNode.getNodeName().equals("services")) {
                        String[] temp = value.split(";");
                        ArrayList<String> hosts = new ArrayList<String>();
                        int k = 0;
                        while (k < temp.length) {
                            hosts.add(temp[k]);
                            ++k;
                        }
                        Collections.sort(hosts);
                        result[0] = value = jdCaptcha.implode(hosts, ";");
                    }
                    if (attributeNode.getNodeName().equals("dst") || attributeNode.getNodeName().equals("src")) {
                        String[] temp = value.split("-");
                        value = String.valueOf(temp[0]) + "-" + newId + ".";
                        temp = temp[1].split("\\.");
                        value = String.valueOf(value) + temp[1];
                        result[1] = temp[0];
                    }
                    jacinfo.print("=\"" + value + "\"");
                    ++j;
                }
                jacinfo.println(" />");
            }
            ++i;
        }
        jacinfo.println("</jDownloader>");
        jacinfo.close();
        return result;
    }

    public static String implode(List<String> ary, String delim) {
        String out = "";
        int i = 0;
        while (i < ary.size()) {
            if (i != 0) {
                out = String.valueOf(out) + delim;
            }
            out = String.valueOf(out) + ary.get(i);
            ++i;
        }
        return out;
    }
}

